/****** Object:  StoredProcedure [dbo].[usp_Update_Admission_Event]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Update_Admission_Event]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Update_Admission_Event]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		silvicap
-- Create date: 24.10.2012
-- Description:	Update admission event.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Update_Admission_Event] 
	@ID	INT,
	@DOMAIN_ID VARCHAR(50),
	@PATIENT_UID UNIQUEIDENTIFIER,
	@IEN VARCHAR(50),
	@ENTERED_DATE DATETIME,	
	@BED_UID UNIQUEIDENTIFIER,
	@WARD_UID UNIQUEIDENTIFIER,
	@VISTA_SITE_UID UNIQUEIDENTIFIER,
	@ATND_NURSE_UID	UNIQUEIDENTIFIER,
	@ADMISSION_DATE	DATETIME,
	@ENTERED_BY_UID	UNIQUEIDENTIFIER,
	@TYPE_OF_MOVEMENT_CODE VARCHAR(100),
	@TYPE_OF_MOVEMENT_CODE_SYSTEM VARCHAR(100),
	@TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME VARCHAR(100),
	@TYPE_OF_MOVEMENT_DISPLAY_NAME VARCHAR(250),
	@HAS_DISCHARGE BIT

AS
SET NOCOUNT ON

BEGIN

	DECLARE @TYPE_OF_MOVEMENT_ID INT
	--TYPE OF MOVEMENT EXISTENCE CHECK
	EXEC DBO.USP_MANAGE_CONCEPT 
		@CODE = @TYPE_OF_MOVEMENT_CODE, 
		@CODE_SYSTEM = @TYPE_OF_MOVEMENT_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @TYPE_OF_MOVEMENT_DISPLAY_NAME, 
		@ID = @TYPE_OF_MOVEMENT_ID OUTPUT

	UPDATE ADMISSION_EVN
		SET
		    DOMAIN_ID = @DOMAIN_ID,
		    IEN = @IEN,
		    PATIENT_UID = @PATIENT_UID,
		    ENTERED_DATE = @ENTERED_DATE,
		    HAS_DISCHARGE = @HAS_DISCHARGE,
			BED_UID = @BED_UID,
			WARD_UID = @WARD_UID,
			VISTA_SITE_UID = @VISTA_SITE_UID,
			ATND_NURSE_UID = @ATND_NURSE_UID,
			ADMISSION_DATE = @ADMISSION_DATE,
			ENTERED_BY_UID = @ENTERED_BY_UID,
			TYPE_OF_MOVEMENT_ID = @TYPE_OF_MOVEMENT_ID
		WHERE ID = @ID

IF @@ERROR<>0 RETURN
END
GO
